<?php  
session_start();
require '../../koneksi.php';
require '../fungsi/rupiah.php';

$id = $_GET['id_order'];

// Ambil data transaksi + keterangan order
$q_struk = mysqli_query($kon, "
    SELECT t.*, o.keterangan_order 
    FROM tb_transaksi t
    LEFT JOIN tb_order o ON o.id_order = t.id_order
    WHERE t.id_order = '$id'
");
$struk   = mysqli_fetch_assoc($q_struk);

// Ambil data member
$q_mem = mysqli_query($kon, "SELECT * FROM tb_user WHERE id_user = '{$struk['id_user']}'");
$mem   = mysqli_fetch_assoc($q_mem);

// Ambil detail order + nama masakan
$detail_order = mysqli_query($kon, "
    SELECT d.*, m.nama_masakan, m.harga_masakan
    FROM tb_detail_order d
    LEFT JOIN tb_masakan m ON m.id_masakan = d.id_masakan
    WHERE d.id_order = '$id'
");
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Invoice</title>
<style>
    body { 
        font-family: 'Courier New', monospace; 
        font-size: 14px; 
        margin: 0; 
        padding: 0;
    }
    .struk { 
        width: 100%; 
        max-width: 148mm; /* A5 width */
        margin: auto; 
        border: 1px solid #000; 
        padding: 15px;
    }
    .title { 
        font-size: 20px; 
        font-weight: bold; 
        text-align: center; 
        margin-bottom: 5px;
    }
    hr { 
        border-top: 1px dashed #000; 
        margin: 8px 0; 
    }
    table { 
        width: 100%; 
        border-collapse: collapse; 
        font-size: 14px;
    }
    th, td { 
        padding: 6px; 
        border: 1px solid #000; 
    }
    th { 
        background: #f2f2f2; 
        text-align: center; 
    }
    .right { text-align: right; }
    .center { text-align: center; }

    /* Print setting */
    @media print {
        @page {
            size: A5;
            margin: 10mm;
        }
        body { margin: 0; }
        .struk { border: none; padding: 0; }
    }
</style>
</head>
<body>
<div class="struk">
    <!-- Header -->
    <h4 class="title">SABLON SOUTHERN</h4>
    <hr>
    <div>
        <strong>Tanggal:</strong> <?= date('d-m-Y H:i', $struk['tanggal_transaksi']) ?><br>
        <strong>No Order:</strong> <?= $struk['id_order'] ?><br>
        <strong>Pelanggan:</strong> <?= $struk['keterangan_order'] ?><br>
    </div>
    <hr>

    <!-- Detail Order -->
    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th>Harga</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($do = mysqli_fetch_assoc($detail_order)): ?>
            <tr>
                <td><?= $do['nama_masakan'] ?></td>
                <td class="right"><?= $do['jumlah_dorder'] ?></td>
                <td class="right"><?= rupiah($do['harga_masakan']) ?></td>
                <td class="right"><?= rupiah($do['hartot_dorder']) ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
    <br>

    <!-- Total -->
    <table>
        <tr>
            <td colspan="3" class="right"><strong>Subtotal</strong></td>
            <td class="right"><?= rupiah($struk['hartot_transaksi']) ?></td>
        </tr>
        <tr>
            <td colspan="3" class="right"><strong>Diskon</strong></td>
            <td class="right"><?= $struk['diskon_transaksi'] ?> %</td>
        </tr>
        <tr>
            <td colspan="3" class="right"><strong>Total</strong></td>
            <td class="right"><?= rupiah($struk['totbar_transaksi']) ?></td>
        </tr>
        <tr>
            <td colspan="3" class="right"><strong>Tunai</strong></td>
            <td class="right"><?= rupiah($struk['uang_transaksi']) ?></td>
        </tr>
        <tr>
            <td colspan="3" class="right"><strong>Kembalian</strong></td>
            <td class="right"><?= rupiah($struk['kembalian_transaksi']) ?></td>
        </tr>
    </table>
    <br>

    <!-- Footer -->
    <div class="center">
        <p><strong>Terima Kasih</strong><br>Atas Kunjungan Anda</p>
    </div>
</div>

<script>window.print();</script>
</body>
</html>
